//
// API for ATI Tray Tools 
// Delphi version
// (c) 2004, 2005 Ray Adams
//
//
//
//
unit plugins;

interface
uses windows;
const ATT_Sign:dword=$4154544C;
const
        //Plugins type
        PL_STD=0;// standard plugin
        PL_RunTime=1;//Run Time plugin
        PL_OSD=2;//OSD Plugins
        PL_MG=3;//Monitoring Graphs

        atc_getversion=1;
        //Get ATT Version
        //inData = 0
        //outData pointer to word , hi byte - HI Version, low byte = Low version

        atc_getDriverRegKey=2;
        //Get currect registry path for catalyst driver
        //inData=0
        //outData = PAnsiChar,
        //Must be allocated in plug-in and have enough space to store path, >=255 will be enough

        atc_IsLDInstalled=3;
        //Check if low lever driver was installed
        //inData=0
        //outData = pointer to byte
        // 1 = yes
        // 2 = no

        atc_inb=4;
        atc_inw=5;
        atc_ind=6;
        //read Byte/Word/Dword from port
        //inData = pointer to TPortIO port
        //outData = pointer to dword, result
        atc_outb=7;
        atc_outw=8;
        atc_outd=9;
        //write Byte/Word/Dword to port
        //inData = pointer to TPortIO record
        //      port to write
        //      value to write
        //outData = pointer to dword, result

        atc_getPCIBusDataB=10;
        atc_getPCIBusDataW=11;
        atc_getPCIBusDataD=12;

        //read Byte/Word/Dword from PCI registers
        //inData = pointer to TPCIIO record
        //     used only bus,device,func, offset
        //outData = pointer to dword, result

        atc_getClocks=13;
        //read current clocks
        //inData = 0
        //outData = pointer to dword
        //hi part : memory
        //lo part : GPU

        atc_setClocks=14;
        //set clocks. PLEASE BE CAREFUL!!!
        //inData = pointer to dword (4 bytes)
        //hi part : memory
        //lo part : GPU
        // outData=0
        atc_ReadDefaultClocks=15;
        //read default clocks from BIOS
        //inData = 0
        //outData = pointer to dword
        //hi part : memory
        //lo part : GPU
        atc_MapMemory=16;
        //Map frame buffer from physical address space to linear
        //inData = pointer to TMemoryMapping
        //outData = pointer to dword (variable with address of mapped memory)
        atc_UnMapMemory=17;
        //Unmap IO memory
        //inData = pointer to variable returned by atc_MapMemory
        //outData = 0
        atc_MRRReadB=18;
        //Read byte from MMR
        //inData = pointer to word as offset in MMR
        //outDate = pointer to byte
        atc_MRRReadW=19;
        //Read byte from MMR
        //inData = pointer to word as offset in MMR
        //outDate = pointer to word
        atc_MRRReadD=20;
        //Read byte from MMR
        //inData = pointer to word as offset in MMR
        //outDate = pointer to dword
        atc_MRRWriteB=21;
        //Writebyte from MMR
        //inData = pointer to word as offset in MMR
        //outDate = pointer to byte (value to write)
        atc_MRRWriteW=22;
        //Write word to MMR
        //inData = pointer to word as offset in MMR
        //outDate = pointer to word (value to write)
        atc_MRRWriteD=23;
        //Write dword to MMR
        //inData = pointer to word as offset in MMR
        //outDate = pointer to dword (value to write)

        atc_setPCIBusDataB=24;
        atc_setPCIBusDataW=25;
        atc_setPCIBusDataD=26;

        //write Byte/Word/Dword to PCI registers
        //inData = pointer to TPCIIO record
        //     used all values: bus,device,func, offset, value
        //outData = nothing

        atc_VIDBusDataB=27;
        atc_VIDBusDataW=28;
        atc_VIDBusDataD=29;
        //Read PCI registers from current video card
        //inData - register
        //outData - pointer to variable to receive value from registers
        //Temperature monitoring
        atc_tmsupport=30;
        //inData - none
        //outData - pointer to to TMonSupport record
        //
        atc_mbmsupported=31;
        //inData none
        //outData TChipProperties
        atc_getmbm_source_name=32;
        //inData - dword index of source
        // starting from tempretaures, next VoltagesCount and last RPMsCount (fans)
        // so first index is always 0
        // total indexes is VoltagesCount+TemperaturesCount+RPMsCount
        //outData PAnsiChar is name of source
        atc_getmbm_source_val=33;
        //inData - index (same as above)
        //outData - pointer to float
        atc_getmsr=34;
        //inData - dword MSR Register
        //outData - pointer to int64
        atc_readi2c=35;  //Read I2C (Only for X1xxx boards yet)
        //inData - pointer to TReadI2C
        //outData - pointer to byte

        atc_load2d=36; //Load default 2D Overclocking profile

        atc_load3d=37; //Load default 3D Overclocking profile

  type PReadI2C=^TReadI2C;
       TReadI2C=packed record
       I2CBus:dword;
       I2CAddr:dword;
       I2CRegister:dword;
       I2CReadStatus:dword;// ATT will write here status of operation
  end;
  type tmbmChipProp = packed record
    isSupported:dword;
    VoltagesCount,
    Presets,
    TemperaturesCount,
    RPMsCount,
    PWMsCount: dword;
  end;

    type TPortIO=packed record
         port:word;
         value:dword;
    end;
    type TPCIIO=packed record
         bus,device,func,offset:byte;
         value:dword;
    end;
    type TMemoryMapping=packed record
         addr:dword;
         size:dword;
         end;
    type TPlugInfo=packed record
         Sign:dword;//std 4 chars to identofy itself as a ATT plugin
         Menu_Text:array[0..50] of ansichar; // text for menu
         PuginType:byte; //type of plugin reserved must be PL_STD
    end;
    type TMonSupport=packed record
         SensorSupported:dword; //1 if supported
         SensorName:array[0..10] of ansichar; //sensor name (lm63, fintek)
         TempGpu:dword;
         TempEnv:dword;
         FanDuty:dword;
    end;
    type PMonSupport=^TMonSupport;

    Tget_plug_info=procedure (var Info:TPlugInfo);stdcall;
    Texec_plugin=procedure(Win_Handle:integer;ATT_Proc:Pointer);stdcall;
    Tatt_proc=procedure (ACommand:longint;inData,outData:pointer);stdcall;
    //Only for RunTime plugins
    //This procedure will be executed by ATT before terminate
    Tdone_plugin=procedure();stdcall;
    //This procedure will be exceuted after restoring system from suspend/hibernate mode
    //Plug-In must decide what to do at this time.
    //if you don't need any actions just create dummy procedure
    Tsuspend_restore=procedure();stdcall;
    //Run Configuration for plugin
    Tconfig_plugin=procedure(Win_Handle:THandle;ATT_Proc:Pointer);stdcall;

    //Only for OSD Plugins
    Tget_osd_string=procedure(OSDstring:PAnsiChar);stdcall;


//Monitroing Graphs Plugins
/////////////////////////////////
// Only for MGP Plugins
/////////////////////////////////
Tstart_mr_plugin=procedure ();stdcall;
// Start Plugin

Tget_mr_count=function ():DWORD;stdcall;
// Return count of monitoring sources supported

Tget_mr_name=procedure (source_index:dword;source_name:PAnsichar);stdcall;
// Return name of monitoring source by index (source_index)

Tget_mr_value=function(source_index:dword):real;stdcall;
// Return current value for source by index

Tget_mr_status=function(source_index:dword):dword;stdcall;
// Return current status 1-enabled, 0-disabled

implementation

end.
